<?php
/**
 * Custom post types and taxonomies.
 *
 * @package JPost
 */

namespace JPost;

/**
 * Register post type wrapper.
 *
 * @param string $slug The slug of CPT..
 * @param array  $label_array Array of labels for CPT.
 * @param array  $arguments Array of custom arguments for CPT.
 *
 * @return void
 */
function post_type_register( string $slug, array $label_array = array(), array $arguments = array() ): void {
	$labels        = array(
		'name'          => str_replace( '_', ' ', ucfirst( $slug ) ),
		'singular_name' => str_replace( '_', ' ', ucfirst( $slug ) ),
	);
	$parsed_labels = wp_parse_args( $label_array, $labels );

	$args = array(
		'labels'              => $parsed_labels,
		'description'         => $parsed_labels['name'],
		'public'              => true,
		'show_ui'             => true,
		'delete_with_user'    => false,
		'show_in_rest'        => true,
		'has_archive'         => true,
		'exclude_from_search' => false,
		'map_meta_cap'        => true,
		'rewrite'             => array(
			'slug'       => $slug,
			'with_front' => true,
		),
		'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
	);

	$parsed_args = wp_parse_args( $arguments, $args );

	register_post_type( $slug, $parsed_args );
}

/**
 * Register taxonomy wrapper.
 *
 * @param string $slug The taxonomy slug.
 * @param array  $post_types Array of post types to associate taxonomy with.
 * @param array  $label_array Array of labels for taxonomy.
 * @param array  $arguments Array of custom arguments for taxonomy.
 *
 * @return void
 */
function taxonomy_register( string $slug, array $post_types = array( 'post', 'page' ), array $label_array = array(), array $arguments = array() ): void {
	$labels        = array(
		'name'          => str_replace( '_', ' ', ucfirst( $slug ) ),
		'singular_name' => str_replace( '_', ' ', ucfirst( $slug ) ),
	);
	$parsed_labels = wp_parse_args( $label_array, $labels );

	$rewrite     = array(
		'slug'         => $slug,
		'with_front'   => true,
		'hierarchical' => true,
	);
	$args        = array(
		'labels'            => $parsed_labels,
		'hierarchical'      => true,
		'public'            => true,
		'show_ui'           => true,
		'show_in_rest'      => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => true,
		'show_tagcloud'     => true,
		'rewrite'           => $rewrite,
		'query_var'         => true,
	);
	$parsed_args = wp_parse_args( $arguments, $args );

	register_taxonomy( $slug, $post_types, $parsed_args );
}
