<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName, WordPress.Files.FileName.NotHyphenatedLowercase

/**
 * Is thrown when a user does not have the correct permissions.
 *
 * @package LD_Organization
 */

namespace LD_Organization\Exceptions;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Exception;

/**
 * An exception for when a user does not have the correct permission.
 */
class PermissionException extends Exception {
	/**
	 * Handles toString.
	 *
	 * @return string
	 */
	public function __toString(): string {
		return __CLASS__ . ": [$this->code]: $this->message\n";
	}
}
