<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName, WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * The exception TypeNotFoundException is thrown when a notification type is not found.
 *
 * @package LD_Organization
 */

namespace LD_Organization\Exceptions;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use Exception;

/**
 * This exception is used when a \LD_Organization\Notification is initialized with a faulty/non-existing notification type.
 *
 * @package LD_Organization
 * @since 0.8.0
 */
class TypeNotFoundException extends Exception {
	/**
	 * Handles toString.
	 *
	 * @return string
	 */
	public function __toString(): string {
		return __CLASS__ . ": [$this->code]: $this->message\n";
	}
}
