<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName, WordPress.Files.FileName.NotHyphenatedLowercase
// phpcs:disable Generic.Commenting.DocComment.MissingShort
/**
 * Handles adding fields to the REST fields.
 *
 * @package LD_Organization\Hooks
 */

namespace LD_Organization\Hooks;

/**
 * Adds fields to the essay rest API object that is needed in the frontend.
 *
 * @package LD_Organization\Hooks
 */
class EssayRestFields extends AbstractHook {
	/**
	 * Handles adding the fields to the rest API object for sfwd-essay.
	 *
	 * @return void
	 * @uses learndash_get_post_type_slug
	 */
	final public function add_rest_fields(): void {
		$essay_post_type = learndash_get_post_type_slug( 'essay', 'string' );
		register_rest_field( $essay_post_type, 'essay_details', array( 'get_callback' => array( $this, 'get_extra_essay_data' ) ) );
	}

	/**
	 * Handles fetching additional fields for essays Rest API object.
	 *
	 * @param array $essay The essay object.
	 *
	 * @return array
	 */
	final public function get_extra_essay_data( array $essay ): array {
		if ( ! empty( $essay['id'] ) ) {
			$essay_details              = learndash_get_essay_details( $essay['id'] );
			$essay_details['is_upload'] = false;
			if ( !empty ( get_post_meta( $essay['id'], 'upload', true ) ) ) {
				$essay_details['is_upload'] = true;
				$essay_details['upload']    = get_post_meta( $essay['id'], 'upload', true );
			}
			return $essay_details;
		}
		return array();
	}

	/**
	 * @inheritDoc
	 */
	final public function get_actions(): array {
		return array(
			array(
				'hook'     => 'rest_api_init',
				'callable' => array( $this, 'add_rest_fields' ),
				'priority' => 10,
				'num_args' => 0,
			),
		);
	}

	/**
	 * @inheritDoc
	 */
	final public function get_filters(): array {
		return array();
	}
}
