<?php
/**
 * The notification post type is used by the notification manager to allow for sending of emails.
 *
 * @package LD_Organization
 */

namespace LD_Organization;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

require_once __DIR__ . '/custom-fields/notification-acf.php';

/**
 * Handles registering the notification class.
 *
 * @return void
 * @since 0.8.0
 */
function register_notification_cpt() {
	$labels = array(
		'name'          => __( 'Notifications', 'ld-organization' ),
		'singular_name' => __( 'Notification', 'ld-organization' ),
	);

	$args = array(
		'label'                 => __( 'Notifications', 'ld-organization' ),
		'labels'                => $labels,
		'description'           => '',
		'public'                => true,
		'publicly_queryable'    => true,
		'show_ui'               => true,
		'show_in_rest'          => true,
		'rest_base'             => '',
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		'has_archive'           => false,
		'show_in_menu'          => true,
		'show_in_nav_menus'     => true,
		'delete_with_user'      => false,
		'exclude_from_search'   => true,
		'capability_type'       => 'post',
		'map_meta_cap'          => true,
		'hierarchical'          => false,
		'menu_icon'             => 'dashicons-bell',
		'rewrite'               => array(
			'slug'       => 'notification',
			'with_front' => true,
		),
		'query_var'             => true,
		'supports'              => array( 'title', 'editor', 'comments' ),
	);

	register_post_type( 'notification', $args );
}

add_action( 'init', 'LD_Organization\register_notification_cpt' );


/**
 * Handles the disabling of gutenberg for notification post types.
 *
 * @param bool   $current_status The current status.
 * @param string $post_type The post type.
 *
 * @return bool
 */
function disable_gutenberg( bool $current_status, string $post_type ): bool {
	if ( in_array( $post_type, array( 'form-data', 'notification' ), true ) ) {
		return false;
	}

	return $current_status;
}

add_filter( 'use_block_editor_for_post_type', 'LD_Organization\disable_gutenberg', 10, 2 );


/**
 * Handles adding polylang support by default to the notification CPT.
 *
 * @param array $post_types An array of post types.
 * @param bool $is_settings If the filter is called in settings, can be used to hide the choice for this CPT.
 *
 * @return array
 */
function add_notification_polylang_support( array $post_types, bool $is_settings ): array {
	if ( $is_settings ) {
		// To hide the notification post type from options.
		unset( $post_types['notification'] );
	} else {
		// Enable polylang for notification post types.
		$post_types['notification'] = 'notification';
	}

	return $post_types;
}

add_filter( 'pll_get_post_types', 'LD_Organization\add_notification_polylang_support', 10, 2 );


