<?php
/**
 * This file include different WP built in function overrides.
 *
 * @since 0.15.0 Added overrides.
 * @package LD_Organization
 */

use function LD_Organization\send_email;

if ( ! function_exists( 'wp_new_user_notification' ) ) {
	/** This function is documented in wp-includes/pluggable.php */ // @phpcs:ignore Squiz.Commenting.FunctionComment.MissingParamTag
	function wp_new_user_notification( int $user_id, $deprecated = null, string $notify = '' ) { // @phpcs:ignore Squiz.Commenting.FunctionComment.Missing
		if ( null !== $deprecated ) {
			_deprecated_argument( __FUNCTION__, '4.3.1' );
		}

		$user = new WP_User( $user_id );

		$user_login = stripslashes( $user->user_login );
		$user_email = stripslashes( $user->user_email );

		$key = get_password_reset_key( $user );
		if ( ! is_wp_error( $key ) ) {
			$url = wp_login_url() . '?action=rp&key=' . $key . '&login=' . rawurlencode( $user->user_login );
		} else {
			$url = wp_login_url();
		}

		$email_data = array(
			'username'  => $user_login,
			'email'     => $user_email,
			'login_url' => $url,
		);

		send_email( 'Kädenjälki <noreply@kadenjalki.fi>', $user_email, $email_data, 'new-user' );
	}
}
