<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName, WordPress.Files.FileName.NotHyphenatedLowercase
// phpcs:disable Generic.Commenting.DocComment.MissingShort
/**
 * Handles adding fields to the REST fields.
 *
 * @package LD_Organization\Hooks
 */

namespace LD_Organization\Hooks;

use LD_Organization\LDOrgTransientManager;
use WP_REST_Request;
use function LD_Organization\calculate_groups_course_progress;
use function LD_Organization\get_default_image_url;

/**
 * Adds fields to the Group Rest API object that are needed in the frontend.
 *
 * @package LD_Organization\Hooks
 */
class GroupRestFields extends AbstractHook {
	/**
	 * Handles adding the fields to the rest API object for sfwd-groups.
	 *
	 * @return void
	 * @uses learndash_get_post_type_slug
	 */
	final public function add_rest_fields(): void {
		$group_post_type = learndash_get_post_type_slug( 'group', 'string' );
		register_rest_field( $group_post_type, 'user_amount', array( 'get_callback' => array( $this, 'get_user_amount' ) ) );
	}

	/**
	 * Handles fetching additional fields for Group Rest API object.
	 *
	 * @param array $group The prepared group from the Rest API object.
	 *
	 * @return int
	 */
	final public function get_user_amount( array $group ): int {
		if ( ! empty( $group['id'] ) ) {
			$amount = learndash_get_groups_user_ids( $group['id'] );
			return count( $amount );
		}
		return 0;
	}

	/**
	 * @inheritDoc
	 */
	final public function get_actions(): array {
		return array(
			array(
				'hook'     => 'rest_api_init',
				'callable' => array( $this, 'add_rest_fields' ),
				'priority' => 99,
				'num_args' => 0,
			),
		);
	}

	/**
	 * @inheritDoc
	 */
	final public function get_filters(): array {
		return array();
	}
}
