<?php // phpcs:ignore Squiz.Commenting.FileComment.Missing
/**
 * Plugin Name:     Learndash - Organizations
 * Plugin URI:      https://plugins.jco.fi/repo
 * Description:     Implements Learndash organizations which can be used to sell licenses to organizations.
 * Author:          J&Co Digital
 * Author URI:      https://jco.fi
 * Text Domain:     ld-organization
 * Domain Path:     /languages
 * Version:         0.18.16
 *
 * @package         LD_Organization
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( is_readable( __DIR__ . '/vendor/autoload.php' ) ) {
	require_once __DIR__ . '/vendor/autoload.php';
} elseif ( is_readable( ABSPATH . '/vendor/autoload.php' ) ) {
	require_once ABSPATH . '/vendor/autoload.php';
}

require __DIR__ . '/consts.php';
require __DIR__ . '/includes/overrides.php';
require __DIR__ . '/includes/helpers.php';
require __DIR__ . '/post-types/custom-fields/options.php';
require __DIR__ . '/post-types/organization.php';
require __DIR__ . '/post-types/notification.php';
require __DIR__ . '/post-types/organization-hooks.php';
require __DIR__ . '/post-types/custom-fields/organization-acf.php';
require __DIR__ . '/post-types/custom-fields/groups-acf.php';
require __DIR__ . '/admin/scripts.php';
require __DIR__ . '/ldlms/course-functions.php';
require __DIR__ . '/ldlms/group-functions.php';
require __DIR__ . '/ldlms/quiz-functions.php';

new LD_Organization\Rest\RestAPI();

add_action( 'init', 'LD_Organization\register_options_page' );
add_action( 'admin_init', 'check_prerequisites' );

/**
 * Handles all pre checks for the plugin.
 *
 * @return void
 */
function check_prerequisites() {
	if ( is_admin() && current_user_can( 'activate_plugins' ) ) {

		$pass = true;

		if ( ! is_plugin_active( 'sfwd-lms/sfwd_lms.php' ) ) {
			add_action( 'admin_notices', 'require_learndash_notice' );
			$pass = false;
		}

		if ( ! class_exists( 'ACF' ) ) {
			add_action( 'admin_notices', 'require_acf_notice' );
			$pass = false;
		}

		if ( ! $pass ) {
			deactivate_plugins( plugin_basename( __FILE__ ) );
			// Ignore this as we are not doing anything else with the get variable than checking/unsetting it.
			// phpcs:ignore
			if ( isset( $_GET['activate'] ) ) {
				// phpcs:ignore
				unset( $_GET['activate'] );
			}
		}
	}
}

/**
 * Adds a notice for the requirement of learndash.
 *
 * @return void
 */
function require_learndash_notice() {
	$class   = 'notice notice-error';
	$message = __( 'LD-Organization requires Learndash to be installed and activated.', 'ld-organization' );

	printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );
}

/**
 * Adds a notice for the requirement of ACF.
 *
 * @return void
 */
function require_acf_notice() {
	$class   = 'notice notice-error';
	$message = __( 'LD-Organization requires ACF to be installed and activated.', 'ld-organization' );

	printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );
}

/**
 * Handles loading the language stuff.
 *
 * @return void
 */
function i18nize() {
	load_plugin_textdomain( 'ld-organization', false, basename( __DIR__ ) . '/languages' );
}

/**
 * Handles registering all hooks required by the plugin.
 *
 * @return void
 */
function register_hooks() {
	// Generic hooks.
	add_action( 'rest_after_insert_groups', 'LD_Organization\handle_rest_group_creation', 10, 3 );
	add_action( 'plugins_loaded', 'i18nize' );
	new LD_Organization\Hooks\ExportFilters();
	new LD_Organization\Hooks\EssayRestFields();
	new LD_Organization\Hooks\CourseRestFields();
	new LD_Organization\Hooks\GroupRestFields();
	new LD_Organization\Hooks\OrganizationLicenseHooks();
	new LD_Organization\Hooks\OrganizationCustomFields();
	new LD_Organization\Hooks\PolylangRestAPI();

	// Admin page hooks.
	new LD_Organization\Admin\HelperTasks();
}

register_hooks();
