<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName, WordPress.Files.FileName.NotHyphenatedLowercase

/**
 * Has some sane defaults for registering a new admin page.
 *
 * @package LD_Organization\Admin
 */

namespace LD_Organization\Admin;

/**
 * AbstractAdminPage has some sane defaults for registering a new admin page.
 *
 * @package LD_Organization\Admin
 * @since 0.18.0 Added AbstractAdminPage class.
 */
abstract class AbstractAdminPage {

	/**
	 * Which priority should be assigned to the admin_menu hook.
	 *
	 * @var int
	 */
	public int $menu_priority = 10;

	/**
	 * Handles registering the hooks and option pages.
	 */
	public function __construct() {
		if ( is_admin() ) {
			add_action( 'admin_menu', array( $this, 'register_pages' ), $this->menu_priority );
			add_action( 'admin_init', array( $this, 'handle_post' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		}
	}

	/**
	 * Here we can register the pages needed for this admin page.
	 *
	 * @return void
	 */
	abstract public function register_pages(): void;

	/**
	 * Should handle a post request.
	 *
	 * @return void
	 */
	abstract public function handle_post(): void;

	/**
	 * Register and enqueue all the scripts here.
	 *
	 * @param string $hook the current page.
	 *
	 * @return void
	 */
	abstract public function enqueue_scripts( string $hook ): void;
}
