import { babel } from "@rollup/plugin-babel";
import { nodeResolve } from "@rollup/plugin-node-resolve";
import terser from "@rollup/plugin-terser";

export default [
	{
		input: "js/admin/index.js",
		output: {
			file: "js/dist/admin.min.js",
			format: "iife",
			sourcemap: "inline",
		},
		plugins: [babel({ babelHelpers: "bundled" })],
	},
	{
		input: "js/admin/vendor.js",
		output: {
			file: "js/dist/admin-vendor.min.js",
			format: "iife",
			sourcemap: false,
		},
		plugins: [
			nodeResolve(),
			babel({ babelHelpers: "bundled", exclude: "**/node_modules/**" }),
			terser(),
		],
	},
	{
		input: "js/frontend/index.js",
		output: {
			file: "js/dist/frontend.min.js",
			format: "iife",
			sourcemap: "inline",
		},
		plugins: [babel({ babelHelpers: "bundled" })],
	},
];
