<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName, WordPress.Files.FileName.NotHyphenatedLowercase
// phpcs:disable Generic.Commenting.DocComment.MissingShort
/**
 * Handles adding fields to the REST fields.
 *
 * @package LD_Organization\Hooks
 */

namespace LD_Organization\Hooks;

use WP_Post;
use WP_User;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Handles deleting the user activity meta when a course is completed.
 *
 * @package LD_Organization\Hooks
 */
class UserActivityReset extends AbstractHook {
	/**
	 * Handles adding the fields to the rest API object for sfwd-essay.
	 *
	 * @param mixed $args The arguments.
	 * @return void
	 */
	final public function delete_user_activity_meta( mixed $args ): void {
		if ( ! $args ) {
			return;
		}
		if ( ! isset( $args['user'] ) || ! $args['course'] ) {
			return;
		}
		if ( ! $args['user'] instanceof WP_User || ! $args['course'] instanceof WP_Post ) {
			return;
		}
		$user   = $args['user'];
		$course = $args['course'];
		delete_user_meta( $user->ID, 'ld_organization_course_activity_reset_' . $course->ID );
	}

	/**
	 * @inheritDoc
	 */
	final public function get_actions(): array {
		return array(
			array(
				'hook'     => 'learndash_course_completed',
				'callable' => array( $this, 'delete_user_activity_meta' ),
				'priority' => 99,
				'num_args' => 1,
			),
		);
	}

	/**
	 * @inheritDoc
	 */
	final public function get_filters(): array {
		return array();
	}
}
