<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName, WordPress.Files.FileName.NotHyphenatedLowercase

/**
 * All Organization-related exceptions are defined here.
 *
 * @package LD_Organization
 */

namespace LD_Organization\Exceptions;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use Exception;
use Throwable;

/**
 * When a organization is not found.
 */
class OrganizationNotFoundException extends Exception {

	/**
	 * Construct the exception.
	 *
	 * @param string         $message The error message.
	 * @param int            $code The error code.
	 * @param Throwable|null $previous The previous exception.
	 */
	public function __construct( string $message = 'Organization not found', int $code = 0, Throwable $previous = null ) {
		parent::__construct( __( 'Organization not found', 'ld-organization' ), $code, $previous );
	}

	/**
	 * Handles toString.
	 *
	 * @return string
	 */
	public function __toString(): string {
		return __CLASS__ . ": [$this->code]: $this->message\n";
	}
}
