<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName, WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * Helper functions for hooking into learndash export filters.
 *
 * @package LD_Organization\Hooks
 */

namespace LD_Organization\Hooks;

/**
 * Export filter class.
 *
 * @package LD_Organization\Hooks
 * @since 0.11.0 Extends AbstractHook and implements the new filter registering interface.
 */
class ExportFilters extends AbstractHook {

	/**
	 * Registers the filters.
	 */
	public function __construct() {
		$filters = array(
			array(
				'hook'     => 'quiz_export_data',
				'callable' => array( $this, 'filter_quiz_export' ),
				'priority' => 10,
				'num_args' => 3,
			),
		);

		parent::__construct( array(), $filters );
	}

	/**
	 * Checks if our custom parameters are set and filters accordingly.
	 *
	 * @param array $content CSV content.
	 * @param array $users An array of users list.
	 * @param int   $group_id The group ID.
	 *
	 * @return array
	 */
	final public function filter_quiz_export( array $content, array $users, int $group_id ): array {

		if ( empty( $_GET['quiz_id'] ) || empty( $_GET['frontend'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			return $content;
		}

		$quiz_id = (int) $_GET['quiz_id']; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

		return array_filter(
			$content,
			static function ( $r ) use ( $quiz_id ) {
				if ( isset( $r['quiz_id'] ) ) {
					return $r['quiz_id'] === $quiz_id;
				}
				return false;
			}
		);
	}
}
