<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName, WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * Handles adding fields to the REST fields.
 *
 * @package LD_Organization\Hooks
 */

namespace LD_Organization\Hooks;

/**
 * Adds fields to the essay rest API object that is needed in the frontend.
 *
 * @package LD_Organization\Hooks
 */
class EssayRestFields extends AbstractHook {

	/**
	 * Registers the hooks.
	 */
	public function __construct() {
		$actions = array(
			array(
				'hook'     => 'rest_api_init',
				'callable' => array( $this, 'add_rest_fields' ),
				'priority' => 10,
				'num_args' => 0,
			),
		);
		parent::__construct( $actions );
	}

	/**
	 * Handles adding the fields to the rest API object for sfwd-essay.
	 *
	 * @return void
	 */
	final public function add_rest_fields(): void {

	}
}
