<?php
/**
 * Certain helper functions for use in the plugin.
 *
 * @package LD_Organization
 * @since 0.4.0
 */

namespace LD_Organization;

/**
 * Handles fetching the default set image for a given post type.
 *
 * @param string $post_type The post type to fetch the default image for.
 * @param string $size The size (WordPress size) to use.
 *
 * @return string
 */
function get_default_image_url( string $post_type = '', string $size = 'full' ): string {
	$default_image_id = get_field( 'ld_organization_default_image_url_' . $post_type, 'options' );

	if ( isset( $default_image_id ) ) {
		$image_src_array = wp_get_attachment_image_src( $default_image_id, $size );
		if ( ( ! empty( $image_src_array ) ) && ( is_array( $image_src_array ) ) && ( ! empty( $image_src_array[0] ) ) ) {
			return $image_src_array[0];
		}
	}

	return '';
}
