<?php
/**
 * Group helper functions and other functionality.
 *
 * @package LD_Organization
 * @since 0.4.0
 */

namespace LD_Organization;

use InvalidArgumentException;
use WP_Post;
use WP_REST_Request;

/**
 * Handles updating the group if a group is created via the REST API.
 *
 * @param WP_Post         $post The WP_Post object.
 * @param WP_REST_Request $request The REST request object.
 * @param bool            $creating If the post is being created.
 *
 * @return void
 */
function handle_rest_group_creation( WP_Post $post, WP_REST_Request $request, bool $creating ) {
	if ( ! $creating || ! is_user_logged_in() ) {
		return;
	}
	try {
		$user_id      = get_current_user_id();
		$organization = Organization::by_user_id( $user_id );
		$organization->initialize_group( $post->ID, array( $user_id ) );

	} catch ( InvalidArgumentException | OrganizationOutOfLicensesException | OrganizationNotFoundException $e ) {
		return;
	}
}
