<?php
/**
 * Registers the options page and the fields for the options page.
 *
 * @package LD_Organization
 * @since 0.4.0
 */

namespace LD_Organization;

/**
 * Registers the options page and the fields for the options page.
 *
 * @return void
 */
function register_options_page(): void {
	if ( function_exists( 'acf_add_options_page' ) ) {

		acf_add_options_page(
			array(
				'page_title' => 'LearnDash Organization Settings',
				'menu_title' => 'LD Organization Settings',
				'menu_slug'  => 'ld-organization-settings',
				'capability' => 'manage_options',
				'redirect'   => false,
				'icon_url'   => 'dashicons-welcome-learn-more',
				'autoload'   => false,

			)
		);

		register_ld_organization_options_acf();
	}
}

/**
 * Registers the fields for the options page.
 *
 * @return void
 */
function register_ld_organization_options_acf(): void {
	// Registers the default image options.
	if ( function_exists( 'acf_add_local_field_group' ) ) {
		acf_add_local_field_group(
			array(
				'key'                   => 'group_default_image_settings',
				'title'                 => 'Default image settings',
				'fields'                => array(
					array(
						'key'               => 'field_6299cc1e14133',
						'label'             => 'Course placeholder image',
						'name'              => 'ld_organization_default_image_url_course',
						'type'              => 'image',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'return_format'     => 'id',
						'preview_size'      => 'full',
						'library'           => 'all',
						'min_width'         => '',
						'min_height'        => '',
						'min_size'          => '',
						'max_width'         => '',
						'max_height'        => '',
						'max_size'          => '',
						'mime_types'        => '',
						'translations'      => 'ignore',
					),
				),
				'location'              => array(
					array(
						array(
							'param'    => 'options_page',
							'operator' => '==',
							'value'    => 'ld-organization-settings',
						),
					),
				),
				'menu_order'            => 0,
				'position'              => 'acf_after_title',
				'style'                 => 'default',
				'label_placement'       => 'top',
				'instruction_placement' => 'label',
				'hide_on_screen'        => '',
				'active'                => true,
				'description'           => '',
				'show_in_rest'          => 0,
			)
		);
	}
}
