import { readFileSync, writeFileSync } from "fs";

try {
	const pluginFileName = "ld-organization.php";
	const pack = JSON.parse(readFileSync("package.json"));
	const baseFile = readFileSync(pluginFileName);
	const baseString = baseFile
		.toString()
		.replace(/^(.*)Version:.*$/m, `$1Version: ${pack.version}`);
	writeFileSync(pluginFileName, baseString);

	const readmeFile = "readme.txt";
	const readmeString = readFileSync(readmeFile)
		.toString()
		.replace(/^(.*)Stable tag:.*$/m, `$1Stable tag: ${pack.version}`);
	writeFileSync(readmeFile, readmeString);
} catch (error) {
	console.error(error);
}
