<?php
/**
 * Register the custom fields for the quiz post type.
 *
 * @package LD_Organization
 */

namespace LD_Organization;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


add_action(
	'acf/include_fields',
	function () {
		if ( ! function_exists( 'acf_add_local_field_group' ) ) {
			return;
		}

		acf_add_local_field_group(
			array(
				'key'                   => 'group_user_activity',
				'title'                 => 'User Activity',
				'fields'                => array(
					array(
						'key'               => 'field_67ff749b43e20',
						'label'             => 'Should be reset for users?',
						'name'              => 'reset_progress',
						'aria-label'        => '',
						'type'              => 'true_false',
						'instructions'      => 'Should this quiz be reset for user when using the User Activity tool?',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'message'           => '',
						'default_value'     => 0,
						'translations'      => 'copy_once',
						'ui_on_text'        => '',
						'ui_off_text'       => '',
						'ui'                => 1,
					),
				),
				'location'              => array(
					array(
						array(
							'param'    => 'post_type',
							'operator' => '==',
							'value'    => 'sfwd-quiz',
						),
					),
				),
				'menu_order'            => 0,
				'position'              => 'side',
				'style'                 => 'default',
				'label_placement'       => 'top',
				'instruction_placement' => 'label',
				'hide_on_screen'        => '',
				'active'                => true,
				'description'           => '',
				'show_in_rest'          => 0,
			)
		);
	}
);
