<?php
/**
 * Registers the ACF fields for the groups allowing them to be linked to an Organization.
 *
 * @since 0.3.0
 * @package LD_Organization
 */

namespace LD_Organization;

if ( function_exists( 'acf_add_local_field_group' ) ) {

	acf_add_local_field_group(
		array(
			'key'                   => 'group_organization____group_linking',
			'title'                 => 'Organization',
			'fields'                => array(
				array(
					'key'               => 'field_62986d2383481',
					'label'             => 'Organization',
					'name'              => 'group_organization',
					'type'              => 'post_object',
					'instructions'      => 'Select which organization this group belongs to.',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'post_type'         => array(
						0 => 'organization',
					),
					'taxonomy'          => '',
					'allow_null'        => 0,
					'multiple'          => 0,
					'return_format'     => 'id',
					'translations'      => 'ignore',
					'ui'                => 1,
				),
			),
			'location'              => array(
				array(
					array(
						'param'    => 'post_type',
						'operator' => '==',
						'value'    => 'groups',
					),
				),
			),
			'menu_order'            => 0,
			'position'              => 'side',
			'style'                 => 'default',
			'label_placement'       => 'top',
			'instruction_placement' => 'label',
			'hide_on_screen'        => '',
			'active'                => true,
			'description'           => '',
			'show_in_rest'          => 0,
		)
	);

}
