<?php
/**
 * This file has quiz helper functions
 *
 * @since 0.9.0
 * @package LD_Organization
 */

namespace LD_Organization;

use WpProQuiz_Model_StatisticUserMapper;

/**
 * Fetches the statistics based on the ref_id.
 *
 * @param int $ref_id The reference identifier from WP Pro Quiz.
 * @param int $quiz_id The quiz ID used to filter the statistics. (Must be pro_quiz_id).
 *
 * @return array
 * @since 0.9.0
 */
function fetch_quiz_statistics( int $ref_id, int $quiz_id ): array {
	$statistics_mapper = new WpProQuiz_Model_StatisticUserMapper();
	$statistics        = $statistics_mapper->fetchUserStatistic( $ref_id, $quiz_id );

	$final_stats = array();

	foreach ( $statistics as $stat_row ) {
		$final_stats[] = array(
			'_correctCount'        => $stat_row->getCorrectCount(),
			'_incorrectCount'      => $stat_row->getIncorrectCount(),
			'_hintCount'           => $stat_row->getHintCount(),
			'_points'              => $stat_row->getPoints(),
			'_questionTime'        => $stat_row->getQuestionTime(),
			'_questionId'          => $stat_row->getQuestionId(),
			'_questionName'        => $stat_row->getQuestionName(),
			'_gPoints'             => $stat_row->getGPoints(),
			'_categoryId'          => $stat_row->getCategoryId(),
			'_categoryName'        => $stat_row->getCategoryName(),
			'_statisticAnswerData' => $stat_row->getStatisticAnswerData(),
			// '_questionAnswerData'  => $stat_row->getQuestionAnswerData(),
			'_answerType'          => $stat_row->getAnswerType(),
		);
	}

	return $final_stats;

}
