<?php
/**
 * All Organization-related exceptions are defined here.
 *
 * @package LD_Organization
 */

namespace LD_Organization;

use Exception;
use JetBrains\PhpStorm\Internal\LanguageLevelTypeAware;

/**
 * When a organization is not found.
 */
class OrganizationNotFoundException extends Exception {

	public function __construct( $message = 'Organization not found', $code = 0, Throwable $previous = null ) {
		parent::__construct( __( 'Organization not found', 'ld-organization' ), $code, $previous );
	}

	/**
	 * Handles toString.
	 *
	 * @return string
	 */
	public function __toString(): string {
		return __CLASS__ . ": [{$this->code}]: {$this->message}\n";
	}
}
