<?php
/**
 * Plugin Name:     Learndash - Organizations
 * Plugin URI:      https://plugins.jco.fi/repo
 * Description:     Implements learndash organizations which can be used to sell licenses to organizations.
 * Author:          J&Co Digital
 * Author URI:      https://jco.fi
 * Text Domain:     ld-organization
 * Domain Path:     /languages
 * Version:         0.3.2
 *
 * @package         LD_Organization
 */


use function LD_Organization\calculate_groups_course_progress;

require __DIR__ . '/consts.php';
require __DIR__ . '/includes/helpers.php';
require __DIR__ . '/classes/class-organization.php';
require __DIR__ . '/post-types/custom-fields/options.php';
require __DIR__ . '/post-types/organization.php';
require __DIR__ . '/post-types/organization-hooks.php';
require __DIR__ . '/post-types/custom-fields/organization-acf.php';
require __DIR__ . '/post-types/custom-fields/groups-acf.php';
require __DIR__ . '/admin/scripts.php';
require __DIR__ . '/ldlms/course-functions.php';
require __DIR__ . '/classes/class-restapi.php';

new LD_Organization\RestAPI();

add_action( 'init', 'LD_Organization\register_options_page' );
add_action( 'admin_init', 'check_for_learndash_lms' );

/**
 * Handles all pre checks for the plugin.
 *
 * @return void
 */
function check_for_learndash_lms() {
	if ( is_admin() && current_user_can( 'activate_plugins' ) && ! is_plugin_active( 'sfwd-lms/sfwd_lms.php' ) ) {
		add_action( 'admin_notices', 'require_learndash_notice' );

		deactivate_plugins( plugin_basename( __FILE__ ) );

		// Ignore this as we are not doing anything else with the get variable than checking/unsetting it.
		// phpcs:ignore
		if ( isset( $_GET['activate'] ) ) {
			// phpcs:ignore
			unset( $_GET['activate'] );
		}
	}
}

/**
 * Adds a notice for the requirement of learndash.
 *
 * @return void
 */
function require_learndash_notice() {
	$class   = 'notice notice-error';
	$message = __( 'LD-Organization requires Learndash to be installed and activated.', 'ld-organization' );

	printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );
}
