<?php
/**
 * Registers the frontend scripts.
 *
 * @package LD_Organization
 */

namespace LD_Organization;

/**
 * Handles registering and enqueueing the correct scripts for CPT.
 *
 * @param string $hook_suffix The hook suffix for the current screen.
 *
 * @return void
 */
function enqueue_organization_scripts( string $hook_suffix ) {

	if ( 'post.php' === $hook_suffix ) {
		$screen = get_current_screen();

		if ( is_object( $screen ) && POST_TYPE_NAME === $screen->post_type ) {
			wp_enqueue_script( 'ld-org-admin-bundle', LD_ORG_BASE_URL . 'js/dist/admin.min.js', array(), '0.1.0', false );
			$post          = get_post();
			$licenses_used = null;
			if ( ! empty( $post ) ) {
				$licenses_used = get_post_meta( $post->ID, USED_LICENSES_META_KEY, true );
			}
			if ( null !== $licenses_used ) {
				wp_localize_script(
					'ld-org-admin-bundle',
					'license_data',
					array(
						'licenses_used' => $licenses_used,
					)
				);
			}
		}
	}
}

add_action( 'admin_enqueue_scripts', 'LD_Organization\enqueue_organization_scripts' );
