<?php // phpcs:ignore

use Monolog\Handler\RotatingFileHandler;
use Monolog\Level;
use Monolog\Logger;
use Monolog\Processor\IntrospectionProcessor;
use Monolog\Processor\WebProcessor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! is_dir( LD_Organization\LD_ORG_BASE_PATH . '/logs' ) ) {
	wp_mkdir_p( LD_Organization\LD_ORG_BASE_PATH . '/logs' );
}

$level   = wp_get_environment_type() !== 'production' ? Level::Debug : Level::Info;
$handler = new RotatingFileHandler( LD_Organization\LD_ORG_BASE_PATH . '/logs/ld-organization-logs', 7, $level, true, null, false, 'Y-m-d', '{filename}-{date}.log' );

$logger = new Logger( 'LD_Organization' );
$logger->pushHandler( $handler );
if ( wp_get_environment_type() !== 'production' ) {
	$logger->pushProcessor( new WebProcessor() );
	$logger->pushProcessor( new IntrospectionProcessor() );
}

/**
 * Returns the logger instance.
 *
 * @param string $channel Optional channel name.
 *
 * @return Logger
 */
function logger( string $channel = 'LD_Organization' ): Logger {
	global $logger;
	if ( is_null( $logger ) ) {
		$logger = new Logger( $channel );
	}
	if ( $channel !== $logger->getName() ) {
		return $logger->withName( $channel );
	}

	return $logger;
}
