<?php
/**
 * Registers the ACF fields for the organization CPT.
 *
 * @package LD_Organization
 */

namespace LD_Organization;

if ( function_exists( 'acf_add_local_field_group' ) ) {

	acf_add_local_field_group(
		array(
			'key'                   => 'group_organization_settings',
			'title'                 => 'Organization settings',
			'fields'                => array(
				array(
					'key'               => 'field_62907451b3aeb',
					'label'             => 'Organization type',
					'name'              => 'organization_type',
					'type'              => 'select',
					'instructions'      => 'Selects the organization type, school institute or business',
					'required'          => 1,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '60',
						'class' => '',
						'id'    => '',
					),
					'choices'           => array(
						'school'   => 'School institute',
						'business' => 'Business',
					),
					'default_value'     => false,
					'allow_null'        => 0,
					'multiple'          => 0,
					'ui'                => 1,
					'ajax'              => 0,
					'return_format'     => 'value',
					'translations'      => 'ignore',
					'placeholder'       => '',
				),
				array(
					'key'               => 'field_62907364801c1',
					'label'             => 'Licenses',
					'name'              => 'licenses',
					'type'              => 'number',
					'instructions'      => 'The number of licenses available to the organization. (used / left)',
					'required'          => 1,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '40',
						'class' => '',
						'id'    => 'licenses',
					),
					'default_value'     => 0,
					'placeholder'       => '',
					'prepend'           => '0 /',
					'append'            => '',
					'min'               => '',
					'max'               => '',
					'step'              => '',
					'translations'      => 'copy_once',
				),
				array(
					'key'               => 'field_629073ab801c2',
					'label'             => 'Organization owners',
					'name'              => 'organization_owners',
					'type'              => 'user',
					'instructions'      => 'Organization owners are users that when logging in should see the organization dashboard and be able to handle this organization.',
					'required'          => 1,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'role'              => '',
					'allow_null'        => 0,
					'multiple'          => 1,
					'return_format'     => 'object',
					'translations'      => 'ignore',
				),
				array(
					'key'               => 'field_6290740d801c3',
					'label'             => 'Organization group leader',
					'name'              => 'group_leaders',
					'type'              => 'user',
					'instructions'      => 'Organization group leaders are users that will be assigned to the group leader role and can handle groups for this organization',
					'required'          => 1,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'role'              => '',
					'allow_null'        => 0,
					'multiple'          => 1,
					'return_format'     => 'object',
					'translations'      => 'ignore',
				),
			),
			'location'              => array(
				array(
					array(
						'param'    => 'post_type',
						'operator' => '==',
						'value'    => POST_TYPE_NAME,
					),
				),
			),
			'menu_order'            => 0,
			'position'              => 'acf_after_title',
			'style'                 => 'seamless',
			'label_placement'       => 'top',
			'instruction_placement' => 'label',
			'hide_on_screen'        => '',
			'active'                => true,
			'description'           => '',
			'show_in_rest'          => 1,
		)
	);

}
