<?php
/**
 * Generic handlers for different field types.
 *
 * @package jQuestPlugin
 */

namespace jQuestPlugin;

/**
 * Renders a text field.
 *
 * Echoes the rendered field.
 *
 * @param array $args {
 *     Optional. Array of field arguments.
 *
 *     @type string $id    The ID of the field. Default empty string.
 *     @type string $value The value of the field. Default empty string.
 *     @type string $placeholder The placeholder of the field. Default empty string.
 * }
 * @return void
 */
function render_text_field( array $args = array() ): void {
	$data = wp_parse_args(
		$args,
		array(
			'id'          => '',
			'value'       => '',
			'placeholder' => '',
		)
	);
	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	echo render_template( 'fields/text', $data );
}
