<?php
/**
 * Bootstraps the elementor widgets.
 *
 * @package JcoreIIT\Blocks
 */

namespace JcoreIIT\Widgets;

class Bootstrap {
	/**
	 * Initializes the class.
	 */
	public static function init(): void {

		function elementor_active(): void
		{
			if (is_plugin_active( 'elementor/elementor.php' )) {
				function register_widget( $widgets_manager ): void
				{


					require_once( __DIR__ . '/InteractiveImageToolWidget.php' );
					$widgets_manager->register( new \Interactive_Image_Tool_Widget() );

				}
				add_action( 'elementor/widgets/register', 'JcoreIIT\Widgets\register_widget' );
			}
		}
		add_action( 'init', 'JcoreIIT\Widgets\elementor_active' );

	}

}
