<?php
/**
 * Bootstraps the blocks.
 *
 * @package JcoreIIT\Blocks
 */

namespace JcoreIIT\Blocks;

use Timber\Timber;

/**
 * Bootstraps all the blocks.
 *
 * @package JcoreIIT\Blocks
 */
class Bootstrap {
	/**
	 * Initializes the class.
	 */
	public static function init(): void {

		self::timber_init();

		$blocks = array(
			InteractiveImageTool::class,
		);

		foreach ( $blocks as $block ) {
			new $block();
		}
	}

	/**
	 * Initializes Timber.
	 *
	 * @return void
	 */
	private static function timber_init(): void {
		add_filter('timber/locations', function ($paths) {
			$paths[] = [JCORE_IIT_PLUGIN_PATH . '/views'];

			return $paths;
		});
	}

}
