const jcoreToggle = []

// Initialize Menu Elements
const menuInit = () => {
	getToggle()
	getTrigger()
}

const getToggle = () => {
	document.querySelectorAll('[data-jtoggle]').forEach((toggle) => {
		const targetClass = toggle.dataset.class ? toggle.dataset.class : 'toggle'
		const timeout = toggle.dataset.timeout ? toggle.dataset.timeout : 200
		const group = toggle.dataset.group ? toggle.dataset.group : null
		const targets = toggle.dataset.jtoggle.split(' ').map(t => {
			return document.getElementById(t)
		}).filter(t => {
			return t !== null
		})
		const toggleItem = {
			element: toggle,
			targets,
			targetClass,
			timeout,
			group
		}
		jcoreToggle.push(toggleItem)
		updateClass(toggle, targets, targetClass, hasClass(toggle, targetClass))
		if (('jhover' in toggle.dataset)) {
			toggle.addEventListener('mouseenter', () => {
				toggleHandler(toggleItem)
			})
			toggle.addEventListener('mouseleave', () => {
				toggleHandler(toggleItem)
			})
		} else {
			toggle.addEventListener('click', () => {
				toggleHandler(toggleItem)
			})
		}
	})
}

const getTrigger = () => {
	document.querySelectorAll('[data-jtrigger]').forEach((trigger) => {
		const targets = trigger.dataset.jtrigger.split(' ').map(t => {
			return document.getElementById(t)
		}).filter(t => {
			return t !== null
		})
		trigger.addEventListener('click', () => {
			targets.forEach(target => {
				target.click()
			})
		})
	})
}

// Handle the toggle action
const toggleHandler = (toggleItem) => {
	const activate = !hasClass(toggleItem.element, toggleItem.targetClass)
	if (activate && toggleItem.group) {
		// If item has group set, look for all other group elements.
		jcoreToggle.forEach(item => {
			if (item.group === toggleItem.group && hasClass(item.element, item.targetClass)) {
				// Deactivate all active group elements.
				updateClass(item.element, item.targets, item.targetClass, false, item.timeout)
			}
		})
	}
	updateClass(toggleItem.element, toggleItem.targets, toggleItem.targetClass, activate, toggleItem.timeout)
}

// Update the toggle class for all elements
const updateClass = (element, targets, targetClass, active, timeout = null) => {
	element.setAttribute('aria-expanded', active ? 'true' : 'false');
	[element, ...targets].forEach(target => {
		if (active) {
			activate(target, targetClass, timeout)
		} else {
			deactivate(target, targetClass, timeout)
		}
	})
}

const activate = (element, targetClass, timeout = null) => {
	addClass(element, targetClass)
	if (timeout) {
		addClass(element, 'activate')
		setTimeout(() => {
			removeClass(element, 'activate')
		}, timeout)
	}
}
const deactivate = (element, targetClass, timeout = null) => {
	removeClass(element, targetClass)
	if (timeout) {
		addClass(element, 'deactivate')
		setTimeout(() => {
			removeClass(element, 'deactivate')
		}, timeout)
	}
}

// Add class to element
const addClass = (element, className) => {
	const classes = element.className ? element.className.split(' ') : []
	if (classes.indexOf(className) === -1) {
		classes.push(className)
		element.className = classes.join(' ')
	}
}
// Remove class to element
const removeClass = (element, className) => {
	const classes = element.className ? element.className.split(' ') : []
	const index = classes.indexOf(className)
	if (index !== -1) {
		classes.splice(index, 1)
		element.className = classes.join(' ')
	}
}
// Check if element has class
const hasClass = (element, className) => {
	const classes = element.className ? element.className.split(' ') : []
	return (classes.indexOf(className) !== -1)
}

window.addEventListener('load', menuInit)
