<?php
/**
 * Plugin Name:     JCORE iiT
 * Plugin URI:      https://jco.fi
 * Description:     The JCORE Interactive Image Tool plugin.
 * Author:          J&Co Digital Oy
 * Author URI:      https://jco.fi
 * Text Domain:     jcore-iit
 * Domain Path:     /languages
 * Version:         0.1.0
 *
 * @package         JcoreIIT
 */

namespace JcoreIIT;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once __DIR__ . '/consts.php';

// Load regular composer autoloader.
if ( is_readable( __DIR__ . JCORE_IIT_COMPOSER_AUTOLOADER ) ) {
	require_once __DIR__ . JCORE_IIT_COMPOSER_AUTOLOADER;
} elseif ( is_readable( ABSPATH . JCORE_IIT_COMPOSER_AUTOLOADER ) ) {
	require_once ABSPATH . JCORE_IIT_COMPOSER_AUTOLOADER;
}

// Load prefixed composer autoloader.
if ( is_readable( __DIR__ . JCORE_IIT_PREFIXED_COMPOSER_AUTOLOADER ) ) {
	require_once __DIR__ . JCORE_IIT_PREFIXED_COMPOSER_AUTOLOADER;
} elseif ( is_readable( ABSPATH . JCORE_IIT_PREFIXED_COMPOSER_AUTOLOADER ) ) {
	require_once ABSPATH . JCORE_IIT_PREFIXED_COMPOSER_AUTOLOADER;
}

require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/includes/acf.php';

/**
 * Checks the prerequisites for the plugin.
 *
 * @return bool
 */
function check_prerequisites(): bool {

	$pass = true;

	if ( ! class_exists( 'JcoreIIT\Blocks\AbstractBlock' ) ) {
		$pass = false;
	}

	// Check that we have ACF installed and activated.
	if ( ! function_exists( 'acf_register_block' ) ) {
		$pass = false;
	}

	if ( $pass ) {
		return true;
	}
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
	\deactivate_plugins( \plugin_basename( __FILE__ ) );
	// Ignore this as we are not doing anything else with the get variable than checking/unsetting it.
	// phpcs:ignore
	if ( isset( $_GET['activate'] ) ) {
		// phpcs:ignore
		unset( $_GET['activate'] );
	}
	add_action( 'admin_notices', __NAMESPACE__ . '\dependencies_errors' );
	return false;
}
add_action( 'plugins_loaded', __NAMESPACE__ . '\check_prerequisites' );

/**
 * Initializes the plugins parts.
 *
 * @return void
 */
function initialize_plugin(): void {
	// Bootstrap the plugins parts, comment out the ones you don't need.
	//Docs\Bootstrap::init();
	Blocks\Bootstrap::init();
	//Options\Bootstrap::init();
}

/**
 * The registration function for the plugin.
 *
 * @return void
 */
function register_plugin_activation_hook(): void {
	$pass = check_prerequisites();
	if ( ! $pass ) {
		return;
	}
}

/**
 * Register styling and scripts
 *
 * @return void
 */
function register_plugin_scripts(): void {
	$plugin_url = plugin_dir_url( __FILE__ );

	//wp_enqueue_style( 'iit-styles', $plugin_url . 'dist/css/iit.css' );
	wp_enqueue_script( 'iit-scripts', $plugin_url . 'dist/js/iit-frontend.js' );
	if ( ! wp_script_is( 'menu') ) {
		wp_enqueue_script( 'menu-iit', $plugin_url . 'dist/js/menu.js' );
	}
}

/**
 * Loads the translations.
 *
 * @return void
 */
function load_translations(): void {
	load_plugin_textdomain( JCORE_IIT_TEXT_DOMAIN, false, basename( __DIR__ ) . '/languages' );
}

register_activation_hook( __FILE__, __NAMESPACE__ . '\register_plugin_activation_hook' );
add_action( 'admin_init', __NAMESPACE__ . '\check_prerequisites' );
add_action( 'plugins_loaded', __NAMESPACE__ . '\load_translations' );
add_action( 'plugins_loaded', __NAMESPACE__ . '\initialize_plugin' );
add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\register_plugin_scripts' );

