window.addEventListener("load", (e) => {
    document.querySelectorAll(".block-interactive_image_tool").forEach((block) => {
        block.querySelectorAll('.hotspot-item').forEach((hotspot) => {
            hotspot.onclick = function (e) {

                // Get elements
                const image = block.querySelector('.hotspot-image');
                const hotspots = block.querySelectorAll('.hotspot-item[data-active="true"]:not([data-index="'+hotspot.dataset.index+'"])');
                const relatedHotspot = block.querySelector('.hotspot[data-index="'+hotspot.dataset.index+'"]');
                const relatedHotspots = block.querySelectorAll('.hotspot[data-active="true"]:not([data-index="'+hotspot.dataset.index+'"])');

                if (!image || !relatedHotspot) return;

                if (!!hotspots) {
                    hotspots.forEach((e) => {
                        if(e.dataset.index !== hotspot.dataset.index){
                            e.dataset.active = "false";
                        }
                    });
                }
                if (!!relatedHotspots){
                    relatedHotspots.forEach((e) => {
                        if(e.dataset.index !== relatedHotspot.dataset.index){
                            e.dataset.active = "false";
                            e.style.left = e.dataset.x + "%";
                            e.style.top = e.dataset.y + "%";
                        }
                    });
                }

                if (hotspot.dataset.active === "true") {
                    hotspot.dataset.active = "false";
                    relatedHotspot.dataset.active = "false";
                    block.dataset.active = "false";

                    // unzoom
                    image.style.transform = 'scale(1)';

                    relatedHotspot.style.left = relatedHotspot.dataset.x + "%";
                    relatedHotspot.style.top = relatedHotspot.dataset.y + "%";

                    image.style.objectPosition = "center";

                } else {
                    hotspot.dataset.active = "true";
                    relatedHotspot.dataset.active = "true";
                    block.dataset.active = "true";

                    // Zoom into element
                    image.style.transform = 'scale(3)';

                    // Get coordinates (Covert to pixel values)
                    let xCoord = image.width / 100 * hotspot.dataset.x;
                    let yCoord = image.height / 100 * hotspot.dataset.y;

                    // Set hotspot in middle of screen
                    relatedHotspot.style.left = 50 + "%";
                    relatedHotspot.style.top = 50 + "%";


                    // Take into account value start position being on top left corner
                    // And object-position starting from middle.
                    xCoord = image.width/2 - xCoord;
                    yCoord = image.height/2 - yCoord;

                    // Adds offset to image edges
                    // Also change position of mobile hotspot due to offset
                    if (Math.abs(xCoord) > image.width/3) {
                        relatedHotspot.style.left = hotspot.dataset.x + "%";
                        xCoord = xCoord - xCoord/3;
                    }
                    if (Math.abs(yCoord) > image.height/3) {
                        relatedHotspot.style.top = hotspot.dataset.y + "%";
                        yCoord = yCoord - yCoord/3;
                    }

                    // Changes image object position
                    image.style.objectPosition = ""+xCoord+"px "+yCoord+"px";
                }

            }
        });
        block.querySelectorAll('.hotspot').forEach((hotspot) => {
            hotspot.onclick = function (e) {
                // Only in mobile view
                if (window.innerWidth <= 576) {
                    const listItem = block.querySelector('.hotspot-item[data-index="'+hotspot.dataset.index+'"]');
                    if (!!listItem && window.getComputedStyle(listItem).display !== "none") listItem.click();
                }
            }
        })
    })

    // Toggles tooltip when clicking outside tooltip
    document.addEventListener("click", (event) => {
        const markers = document.querySelectorAll('.hotspot.toggle');

        markers.forEach((marker) => {
            const hotspotListContainer = document.querySelector("#block-"+marker.dataset.block+" .hotspot-list-container.desktop");
            if (!marker.contains(event.target) && !hotspotListContainer.contains(event.target)) {
                marker.classList.remove('toggle');
                const m = marker.querySelector('.marker.toggle')
                if (!!m) m.classList.remove('toggle');
            }
        })
    });

});
