<?php
/**
 * Interactive Image Tool which allows user to insert hotspots with tooltips.
 *
 * @package JcoreIIT\Blocks
 */

namespace JcoreIIT\Blocks;

/**
 * Example block
 * This is an example of a simple block
 */
class InteractiveImageTool extends AbstractBlock {

	/**
	 * The block name, will be transformed to be compliant with Gutenberg.
	 *
	 * @see https://developer.wordpress.org/block-editor/developers/block-api/block-registration/#block-name
	 *
	 * @var string
	 */
	protected static string $name = 'Interactive_Image_Tool';

	/**
	 * The script name when registered
	 *
	 * @var string
	 */
	protected string $script_name = 'interactive-image-tool';

	/**
	 * The script path relative to the wp-content root
	 *
	 * @var string
	 */
	protected string $script_path = '/plugins/jcore-iit/dist/js/iit-frontend.js';


	/**
	 * Icon, short name of dashicon: eg. admin-page
	 *
	 * @see https://developer.wordpress.org/block-editor/developers/block-api/block-registration/#icon-optional
	 *
	 * @var string
	 */
	protected static string $icon = 'admin-page';
	/**
	 * Keywords for the block, useful for making the block easily searchable
	 *
	 * @see https://developer.wordpress.org/block-editor/developers/block-api/block-registration/#keywords-optional
	 *
	 * @var array
	 */
	protected static array $keywords = array( 'Interactive Image Tool', 'IIT' );

	/**
	 * The supports for the block, we need JSX for this block, and disable the mode switcher.
	 *
	 * @var array
	 */
	protected static array $supports = array(
		'jsx'  => true,
		'mode' => false,
	);

	/**
	 * The mode of the block, can be preview, edit or auto.
	 *
	 * @var string
	 */
	protected static string $mode = 'preview';

	/**
	 * Registers the fields
	 *
	 * @return array
	 */
	public function register_fields(): array {
		return array(
			array(
				'key'               => 'field_6356bbd8cdcb9',
				'label'             => 'Image',
				'name'              => 'image',
				'type'              => 'image',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'return_format'     => 'array',
				'preview_size'      => 'medium',
				'library'           => 'all',
				'min_width'         => '',
				'min_height'        => '',
				'min_size'          => '',
				'max_width'         => '',
				'max_height'        => '',
				'max_size'          => '',
				'mime_types'        => '',
			),
			array(
				'key'               => 'field_636290a13e460',
				'label'             => 'General settings',
				'name'              => '',
				'type'              => 'accordion',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'open'              => 0,
				'multi_expand'      => 0,
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_636290b43e461',
				'label'             => 'Show hotspot index',
				'name'              => 'show_index',
				'type'              => 'true_false',
				'instructions'      => 'Show hotspot index number on frontend?',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'message'           => '',
				'default_value'     => 0,
				'ui'                => 1,
				'ui_on_text'        => '',
				'ui_off_text'       => '',
			),
			array(
				'key'               => 'field_6356bc05f16bc',
				'label'             => 'Hotspots',
				'name'              => '',
				'type'              => 'accordion',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'open'              => 0,
				'multi_expand'      => 0,
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_6356c74236c7c',
				'label'             => '',
				'name'              => 'hotspots',
				'type'              => 'repeater',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'collapsed'         => 'field_635905e2a4d2a',
				'min'               => 0,
				'max'               => 0,
				'layout'            => 'block',
				'button_label'      => 'Add hotspot',
				'sub_fields'        => array(
					array(
						'key'               => 'field_635905e2a4d2a',
						'label'             => 'Title',
						'name'              => 'title',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 1,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_669d1a9a8b1c2',
						'label'             => 'Alignment',
						'name'              => 'alignment',
						'type'              => 'button_group',
						'instructions'      => 'Select the alignment of the hotspot content.',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'choices'           => array(
							'left'   => 'Left',
							'center' => 'Center',
							'right'  => 'Right',
						),
						'allow_null'        => 0,
						'default_value'     => 'center',
						'layout'            => 'horizontal',
						'return_format'     => 'value',
					),
					array(
						'key'               => 'field_635bfe9db41df',
						'label'             => 'Image',
						'name'              => 'image',
						'type'              => 'image',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'return_format'     => 'array',
						'preview_size'      => 'thumbnail',
						'library'           => 'all',
						'min_width'         => '',
						'min_height'        => '',
						'min_size'          => '',
						'max_width'         => '',
						'max_height'        => '',
						'max_size'          => '',
						'mime_types'        => '',
					),
					array(
						'key'               => 'field_6357be55092fd',
						'label'             => 'Text',
						'name'              => 'text',
						'type'              => 'textarea',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'maxlength'         => '',
						'rows'              => '',
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_6359063fa4d2c',
						'label'             => 'Extra link',
						'name'              => 'link',
						'type'              => 'link',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'return_format'     => 'array',
					),
					array(
						'key'               => 'field_635fbe968e349',
						'label'             => 'Coordinates',
						'name'              => '',
						'type'              => 'accordion',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'open'              => 0,
						'multi_expand'      => 0,
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_6356c79617bf4',
						'label'             => 'X-Coordinate',
						'name'              => 'x-cordinate',
						'type'              => 'number',
						'instructions'      => '',
						'required'          => 1,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => 50,
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '%',
						'min'               => 0,
						'max'               => 100,
						'step'              => '',
					),
					array(
						'key'               => 'field_6356c7b517bf5',
						'label'             => 'Y-Coordinate',
						'name'              => 'y-cordinate',
						'type'              => 'number',
						'instructions'      => '',
						'required'          => 1,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => 50,
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '%',
						'min'               => 0,
						'max'               => 100,
						'step'              => '',
					),
				),
			),
		); // ACF generated array goes here.
	}
}
