<?php
/**
 * Plugin Name:     Fix Webtoffee IAB TCF
 * Plugin URI:      https://jco.fi
 * Description:     Fixes the issues with Webtoffee IAB TCF.
 * Author:          J&Co Digital Oy
 * Author URI:      https://jco.fi
 * Text Domain:     fix-webtoffee
 * Domain Path:     /languages
 * Version:         0.1.0
 *
 * @package         Fix_Webtoffee
 */

add_action(
	'plugins_loaded',
	static function () {
		// This will get the IAB-TCF functionality to not load.
		global $wp_filter;
		if ( ! isset( $wp_filter['init'], $wp_filter['init']->callbacks[10], ) ) {
			return;
		}
		if ( ! class_exists( 'Cookie_Law_Iab_Tcf' ) ) {
			return;
		}
		$callbacks = $wp_filter['init']->callbacks[10];
		$keys      = array_keys( $callbacks );
		$keys      = array_values(
			array_filter(
				$keys,
				static function ( $key ) use ( $wp_filter ) {
					$func = $wp_filter['init']->callbacks[10][ $key ]['function'];
					if ( ! is_array( $func ) ) {
						return false;
					}
					if ( ! is_object( $func[0] ) ) {
						return false;
					}
					return $func[0] instanceof \Cookie_Law_Iab_Tcf;
				}
			)
		);
		foreach ( $keys as $key ) {
			unset( $wp_filter['init']->callbacks[10][ $key ] );
		}
	}
);

add_action(
	'init',
	static function () {
		// This will get the IAB-TCF functionality to not load.
		global $wp_filter;
		if ( ! isset( $wp_filter['wp_enqueue_scripts'], $wp_filter['wp_enqueue_scripts']->callbacks[10], ) ) {
			return;
		}
		if ( ! class_exists( 'Cookie_Law_Iab_Tcf' ) ) {
			return;
		}
		$callbacks = $wp_filter['wp_enqueue_scripts']->callbacks[10];
		$keys      = array_keys( $callbacks );
		$keys      = array_values(
			array_filter(
				$keys,
				static function ( $key ) use ( $wp_filter ) {
					$func = $wp_filter['wp_enqueue_scripts']->callbacks[10][ $key ]['function'];
					if ( ! is_array( $func ) ) {
						return false;
					}
					if ( ! is_object( $func[0] ) ) {
						return false;
					}
					return $func[0] instanceof \Cookie_Law_Iab_Tcf;
				}
			)
		);
		foreach ( $keys as $key ) {
			unset( $wp_filter['wp_enqueue_scripts']->callbacks[10][ $key ] );
		}
	}
);
